/**
 * \file: VideoChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto
 *
 * \author: Y. Nakamura / ADITJ / ynakamura@jp.adit-jv.com
 *
 * \copyright (c) 2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

// TODO move to aauto-demo

#ifndef AAUTO_VIDEOCHANNEL_H
#define AAUTO_VIDEOCHANNEL_H


#include <aauto/GalReceiver.h>
#include <aauto/util/scoped_ptr.h>
#include <ilm/ilm_client.h>
#include <ilm/ilm_control.h>
#include <condition_variable>
#include <mutex>

#include "aauto/AditVideoSink.h"
#include "aauto/AautoErrorCodes.h"

#include "utils/IConfiguration.h"

uint64_t getTime();

namespace adit { namespace aauto
{
class VideoChannel : public IAditVideoSinkCallbacks
{
public:
    VideoChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId, bool inAutoStart,
        t_ilm_layer inLayerID, t_ilm_surface inSurfaceID, IDynamicConfiguration& inConfig);
    ~VideoChannel();

    void shutdown();
    bool Initialize();
    void setupCallback(int inMediaCodecType);
    void playbackStartCallback();
    void playbackFirstFrameRenderedCallback();
    void playbackStopCallback();
    void sourceVideoConfigCallback(int inWidth, int inHeight, int inUIResWidth, int inUIResHeight);
    void videoFocusCallback(int inFocus, int inReason);
    void notifyErrorCallback(aautoErrorCodes inErrorCode);
    ::shared_ptr<AditVideoSink> getProtocolEndpoint()
    {
        return endpoint;
    }

private:
    ::shared_ptr<GalReceiver> receiver;
    uint8_t sessionId;
    bool autoStart;
    t_ilm_layer layerID;
    t_ilm_surface surfaceID;
    IDynamicConfiguration* mConfig;

    ::shared_ptr<AditVideoSink> endpoint;

    static void* delayedSwitchBack(void* inData);

    bool mStop;
    std::condition_variable mConditonVar;
    std::mutex mConditionMutex;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_VIDEOCHANNEL_H */
